/*
 * File name: product.c 
 * 
 * Note: for BCM47189 configuration file
 *  
 * Author: 2015-04-01 Sudenghai
 */

#ifndef __LINUX_BCM47189_PRODUCT_H_INCLUDED
#define __LINUX_BCM47189_PRODUCT_H_INCLUDED


#include <gpio.h>
#include <led.h>
#include <btn.h>

/*name Ķ廹ǰǰĶ壬Եledעͣ޸ĶӦGpio*/
struct led_dev bcm47189_leds[] = {
	{led_power, GPIO10, GPIO_LEVEL_LOW, led_off_trig, LED_BOOT_OFF, led_off_trig, 0},
	{led_wps, 	GPIO11, GPIO_LEVEL_LOW, led_off_trig, LED_BOOT_OFF, led_off_trig, 0},
	//{led_wlan, 	GPIO11, GPIO_LEVEL_HIGH, led_off_trig, LED_BOOT_OFF, led_off_trig, 0},
	{led_end, 	GPIO_END, GPIO_LEVEL_HIGH,led_off_trig, LED_BOOT_OFF, led_off_trig, 0},
};

struct btn_dev bcm47189_btns[] = 
{
	{
		.name  = btn_reset,
		.gpio  = GPIO05,
		.level = BTN_LEVEL_LOW,
	},
	{
		.name  = btn_wps,
		.gpio  = GPIO09,
		.level = BTN_LEVEL_LOW,
	},
	{
		.name  = btn_powerline,
		.gpio  = GPIO01,
		.level = BTN_LEVEL_LOW,
	},
	{
		.name  = btn_end,
	},
};

#ifdef _LINUX_KERNEL_H
#include <linux/module.h>
EXPORT_SYMBOL_GPL(bcm47189_leds);
EXPORT_SYMBOL_GPL(bcm47189_btns);
MODULE_LICENSE("GPL");
#endif

#endif /* __LINUX_MT7620A_PRODUCT_H_INCLUDED */

